<?php

namespace frontend\controllers;

use Yii;
use common\models\User;
use common\models\Bots;
use frontend\models\BotsSearch;
use yii\web\Controller;
use yii\web\NotFoundHttpException;
use yii\filters\VerbFilter;
use yii\helpers\Json;

/**
 * BotsdataController implements the CRUD actions for Bots model.
 */
class BotsdataController extends Controller
{
    /**
     * {@inheritdoc}
     */
    public function behaviors()
    {
        return [
            'verbs' => [
                'class' => VerbFilter::className(),
                'actions' => [
                    'delete' => ['POST'],
                ],
            ],
        ];
    }

    /**
     * Lists all Bots models.
     * @return mixed
     */
    public function actionIndex()
    {
        if (Yii::$app->user->isGuest) {
            return $this->goHome();
        }
        
        
        $groupFilter = Yii::$app->request->queryParams['group'];

        if($groupFilter=='autorefreshchanged' && isset(Yii::$app->request->queryParams['a'])){
            User::setUserSettingValue('autorefresh',Yii::$app->request->queryParams['a']);
            return;
        }

        if($groupFilter=='viewmodechanged' && isset(Yii::$app->request->queryParams['a'])){
            User::setUserSettingValue('viewmode',Yii::$app->request->queryParams['a']);
            return;
        }

        // viewmode filter
        $vmode = (array)json_decode(Yii::$app->user->identity->settings);
        if(isset($vmode['viewmode'])){
            $viewmode = str_split($vmode['viewmode']);
            $viewfilter = [];
            $i = 0;
            foreach ($viewmode as $key => $value) {
                if($value==1){
                    array_push($viewfilter, $i);
                }
                $i++;
            }
        }else{
            User::setUserSettingValue('viewmode','100');
            $viewfilter = [1,0,0];
        }

        $searchModel = new BotsSearch();
        $dataProvider = $searchModel->search(Yii::$app->request->queryParams);
        //$dataProvider->sort = ['defaultOrder'=> ['id' => 'ASC']];
        $dataProvider->query->andFilterWhere(['like','group',$groupFilter])->andFilterWhere(['type'=>$viewfilter]);
        if (Yii::$app->request->post('hasEditable')) {
            $commentId = Yii::$app->request->post('editableKey');
            $model = Bots::findOne(['id' => $commentId]);
            $out = Json::encode(['output'=>'', 'message'=>'']);
            $posted = current($_POST['Bots']);
            $model->comment = $posted['comment'];
            $model->save(false);
            Yii::info('User '. Yii::$app->user->identity->username . ' wrote comment to bot ' . $model->bot, $category = 'userinfo');
            echo $out;
            return;
            
        }
        return $this->render('index', [
            'searchModel' => $searchModel,
            'dataProvider' => $dataProvider,
        ]);
    }


    /**
     * Finds the Bots model based on its primary key value.
     * If the model is not found, a 404 HTTP exception will be thrown.
     * @param integer $id
     * @return Bots the loaded model
     * @throws NotFoundHttpException if the model cannot be found
     */
    protected function findModel($id)
    {
        if (($model = Bots::findOne($id)) !== null) {
            return $model;
        }

        throw new NotFoundHttpException('The requested page does not exist.');
    }

}
